/*
 *
 * Komunikacja midzy oknem macierzystym a potomnym
 *
 */
#include <windows.h>
#include <richedit.h>
#include <stdlib.h>

/* Deklaracja wyprzedzajca: funkcja obsugi okna */
LRESULT CALLBACK WindowProcedure(HWND, UINT, WPARAM, LPARAM);
/* Nazwa klasy okna */
char szClassName[] = "PRZYKLAD";

int WINAPI WinMain(HINSTANCE hInstance, 
                   HINSTANCE hPrevInstance, 
                   LPSTR lpCmdLine, 
                   int nShowCmd)
{
    HWND hwnd;               /* Uchwyt okna */
    MSG messages;            /* Komunikaty okna */
    WNDCLASSEX wincl;        /* Struktura klasy okna */

    /* Klasa okna */
    wincl.hInstance     = hInstance;
    wincl.lpszClassName = szClassName;
    wincl.lpfnWndProc   = WindowProcedure;    // wskanik na funkcj 
                                              // obsugi okna  
    wincl.style         = CS_DBLCLKS;                 
    wincl.cbSize        = sizeof(WNDCLASSEX);

    /* Domylna ikona i wskanik myszy */
    wincl.hIcon   = LoadIcon(NULL, IDI_APPLICATION);
    wincl.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
    wincl.hCursor = LoadCursor(NULL, IDC_ARROW);
    wincl.lpszMenuName = NULL; 
    wincl.cbClsExtra = 0;   
    wincl.cbWndExtra = 0;   
    /* Jasnoszare to */
    wincl.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);

    /* Rejestruj klas okna */
    if(!RegisterClassEx(&wincl)) return 0;

    /* Twrz okno */
    hwnd = CreateWindowEx(
           0, szClassName,         
           "Przykad",       
           WS_OVERLAPPEDWINDOW, 
           CW_USEDEFAULT, CW_USEDEFAULT,       
           512, 512,                 
           HWND_DESKTOP, NULL,                
           hInstance, NULL );

    ShowWindow(hwnd, nShowCmd);
    /* Ptla obsugi komunikatw */
    while(GetMessage(&messages, NULL, 0, 0))
    {
           /* Tumacz kody rozszerzone */
           TranslateMessage(&messages);
           /* Obsu komunikat */
           DispatchMessage(&messages);
    }

    /* Zwr parametr podany w PostQuitMessage( ) */
    return messages.wParam;
}

/* ID przycisku */
const int ID_BUTTON  = 100;
const int ID_TEXTBOX = 101;

/* T funkcj woa DispatchMessage( ) */
LRESULT CALLBACK WindowProcedure(HWND hwnd, UINT message, 
                                 WPARAM wParam, LPARAM lParam)
{
    static HWND hButton, hTextBox;
    switch (message)                  
    {
           case WM_CREATE:
                         
              hButton  = CreateWindow( "BUTTON", "Zmie kolor",
                                   WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON,
                                   10, 10, 200, 32, 
                                   hwnd, (HMENU) ID_BUTTON,
                                   ((LPCREATESTRUCT) lParam)->hInstance, 
                                   NULL) ;
              // inicjuj pole RichEdit                                   
              LoadLibrary( "RICHED32.DLL" );
              hTextBox = CreateWindow( "RichEdit", "Tekst",
                                   WS_CHILD | WS_VISIBLE | 
                                   WS_BORDER | ES_MULTILINE,
                                   10, 50, 200, 200, 
                                   hwnd, (HMENU) ID_TEXTBOX,
                                   ((LPCREATESTRUCT) lParam)->hInstance, 
                                   NULL) ;

              break;
           case WM_COMMAND: 
              // jeli kliknito przycisk
              if ( HIWORD(wParam) == BN_CLICKED ) 
              {
                 switch( LOWORD(wParam) )
                 { 
                    // zmie kolor ta pola RichEdit
                    case ID_BUTTON : 
                      SendMessage( hTextBox, EM_SETBKGNDCOLOR, 0, 
                               RGB( rand()%255, rand()%255, rand()%255 ) );
                 } 
              }
              break;
           case WM_DESTROY:
              PostQuitMessage(0);        
              break;
           default:                   
              return DefWindowProc(hwnd, message, wParam, lParam);      
    }              
    return 0;
}
